﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for CustomizeTableLayout.xaml
    /// </summary>
    public partial class CustomizeTableLayout : Window
    {
        private const string FT_BarStool = "BarStool";
        private const string FT_Table = "Table";
        private const string FT_Sofa = "Sofa";

        private const string IMG_BarStool = "pack://application:,,,/Resources/Images/Stools.png";
        private const string IMG_Table = "pack://application:,,,/Resources/Images/table.png";
        private const string IMG_Sofa = "pack://application:,,,/Resources/Images/Sofa.png";

        private Grid draggedGrid;
        private Point mousePosition;

        public CustomizeTableLayout()
        {
            InitializeComponent();
            LoadTables();
            LoadSelectTables();
        }

        private void LoadTables()
        {
            List<Layouts> Tables = LayoutBL.GetList(Guid.Empty);
            if (Tables != null && Tables.Count > 0)
            {
                Tables = Tables.Where(a => a.IsActive).ToList<Layouts>();
            }
            if (Tables != null && Tables.Any())
            {
                foreach (Layouts tbl in Tables)
                {
                    AddItemToCanvas(tbl);
                }
            }
        }

        private void btnAddStoolToCart_Click_1(object sender, RoutedEventArgs e)
        {
            AddItemToCanvas(new Layouts() { TableType = FT_BarStool });
        }

        private void btnAddSofaToCart_Click_1(object sender, RoutedEventArgs e)
        {
            AddItemToCanvas(new Layouts() { TableType = FT_Sofa });
        }

        private void btnAddTableToCart_Click_1(object sender, RoutedEventArgs e)
        {
            AddItemToCanvas(new Layouts() { TableType = FT_Table });
        }

        private void AddItemToCanvas(Layouts TableLayout)
        {
            if (TableLayout != null)
            {
                Grid TableGrid = new Grid();
                TableGrid.Width = 100;
                TableGrid.Height = 105;
                TableGrid.Tag = TableLayout.TableID != null && TableLayout.TableID != Guid.Empty ? TableLayout.TableID : Guid.Empty;

                RowDefinition ImgRow = new RowDefinition();
                ImgRow.Height = new GridLength(60);

                RowDefinition TitleRow = new RowDefinition();
                TitleRow.Height = new GridLength(23);

                RowDefinition SeatsRow = new RowDefinition();
                TitleRow.Height = new GridLength(22);

                TableGrid.RowDefinitions.Add(ImgRow);
                TableGrid.RowDefinitions.Add(TitleRow);
                TableGrid.RowDefinitions.Add(SeatsRow);

                Image deleteImage = new Image();
                deleteImage.Width = 25;
                BitmapImage logo = new BitmapImage();
                logo.BeginInit();
                logo.UriSource = new Uri("pack://application:,,,/Resources/Images/delete.png");
                logo.EndInit();
                deleteImage.Source = logo;
                deleteImage.SetValue(Grid.RowProperty, 0);
                deleteImage.HorizontalAlignment = HorizontalAlignment.Right;
                deleteImage.VerticalAlignment = VerticalAlignment.Top;
                deleteImage.Margin = new Thickness(0, -8, -8, 0);
                //deleteImage.MouseLeftButtonUp +=deleteImage_MouseLeftButtonUp;
                deleteImage.SetValue(Panel.ZIndexProperty, 2);
                deleteImage.Cursor = Cursors.Hand;

                Image finalImage = new Image();
                finalImage.Width = 100;
                logo = new BitmapImage();
                logo.BeginInit();
                switch (TableLayout.TableType)
                {
                    case FT_BarStool:
                        logo.UriSource = new Uri(IMG_BarStool);
                        break;
                    case FT_Table:
                        logo.UriSource = new Uri(IMG_Table);
                        break;
                    case FT_Sofa:
                        logo.UriSource = new Uri(IMG_Sofa);
                        break;
                    default: break;
                }
                logo.EndInit();
                finalImage.Source = logo;
                finalImage.SetValue(Panel.ZIndexProperty, 1);

                finalImage.SetValue(Grid.RowProperty, 0);

                TextBox TableName = new TextBox();
                TableName.Width = 70;
                TableName.Height = 20;
                TableName.MaxLength = 20;
                TableName.VerticalAlignment = VerticalAlignment.Center;
                TableName.HorizontalAlignment = HorizontalAlignment.Center;
                TableName.SetValue(Grid.RowProperty, 1);
                if (TableLayout.TableName != null)
                    TableName.Text = TableLayout.TableName;

                TextBox Seats = new TextBox();
                Seats.Width = 35;
                Seats.Height = 20;
                Seats.MaxLength = 2;
                Seats.VerticalAlignment = VerticalAlignment.Center;
                Seats.HorizontalAlignment = HorizontalAlignment.Left;
                Seats.SetValue(Grid.RowProperty, 2);
                Seats.Text = TableLayout.TableCapacity.ToString();

                TextBlock SeatsText = new TextBlock();
                SeatsText.Width = 35;
                SeatsText.Height = 20;
                SeatsText.VerticalAlignment = VerticalAlignment.Center;
                SeatsText.HorizontalAlignment = HorizontalAlignment.Left;
                SeatsText.Margin = new Thickness(35, 0, 0, 0);
                SeatsText.SetValue(Grid.RowProperty, 2);
                SeatsText.Text = "Seat(s)";
                SeatsText.FontSize = 12;
                SeatsText.Foreground = Brushes.Black;


                TableGrid.Children.Add(finalImage);
                TableGrid.Children.Add(TableName);
                TableGrid.Children.Add(deleteImage);
                TableGrid.Children.Add(SeatsText);
                TableGrid.Children.Add(Seats);

                double leftPosition = string.IsNullOrEmpty(TableLayout.TablePosition) ? 10 : Convert.ToDouble(TableLayout.TablePosition.Substring(0, TableLayout.TablePosition.IndexOf(',')));
                double topPosition = string.IsNullOrEmpty(TableLayout.TablePosition) ? 10 : Convert.ToDouble(TableLayout.TablePosition.Substring(TableLayout.TablePosition.IndexOf(',') + 1, TableLayout.TablePosition.Length - TableLayout.TablePosition.IndexOf(',') - 1));

                Canvas.SetLeft(TableGrid, leftPosition);
                Canvas.SetTop(TableGrid, topPosition);
                MainCanvas.Children.Add(TableGrid);
            }
        }

        private void LoadSelectTables()
        {

            List<Layouts> Tables = LayoutBL.GetList(Guid.Empty);
            if (Tables != null && Tables.Count > 0)
            {
                Tables = Tables.Where(a => a.IsActive).ToList<Layouts>();
            }
            if (Tables != null && Tables.Any())
            {
                SelectCanvas.Children.Clear();
                foreach (Layouts TableLayout in Tables)
                {
                    if (TableLayout != null)
                    {
                        Grid TableGrid = new Grid();
                        TableGrid.Width = 100;
                        TableGrid.Height = 100;
                        TableGrid.Tag = TableLayout.TableID != null && TableLayout.TableID != Guid.Empty ? TableLayout.TableID : Guid.Empty;

                        RowDefinition ImgRow = new RowDefinition();
                        ImgRow.Height = new GridLength(80);

                        RowDefinition TitleRow = new RowDefinition();
                        TitleRow.Height = new GridLength(20);

                       

                        TableGrid.RowDefinitions.Add(ImgRow);
                        TableGrid.RowDefinitions.Add(TitleRow);
                        //TableGrid.RowDefinitions.Add(SeatRow);
                      
                        Image finalImage = new Image();
                        finalImage.Width = 100;
                        BitmapImage logo = new BitmapImage();
                        logo.BeginInit();
                        switch (TableLayout.TableType)
                        {
                            case FT_BarStool:
                                logo.UriSource = new Uri(IMG_BarStool);
                                break;
                            case FT_Table:
                                logo.UriSource = new Uri(IMG_Table);
                                break;
                            case FT_Sofa:
                                logo.UriSource = new Uri(IMG_Sofa);
                                break;
                            default: break;
                        }
                        logo.EndInit();
                        finalImage.Source = logo;
                        finalImage.SetValue(Panel.ZIndexProperty, 1);
                        finalImage.SetValue(Grid.RowProperty, 0);

                        TextBlock TitleText = new TextBlock();
                        TitleText.Width = 100;
                        TitleText.Height = 20;
                        TitleText.VerticalAlignment = VerticalAlignment.Center;
                        TitleText.HorizontalAlignment = HorizontalAlignment.Center;
                        TitleText.TextAlignment = TextAlignment.Center;
                        TitleText.Margin = new Thickness(0, 0, 0, 0);
                        TitleText.SetValue(Grid.RowProperty, 1);
                        TitleText.Text = string.Format("{0}", TableLayout.TableName);
                        TitleText.FontSize = 13;
                        TitleText.FontWeight = FontWeights.Bold;
                        TitleText.TextWrapping = TextWrapping.Wrap;
                        TitleText.Foreground = Brushes.Black;

                        //TextBlock SeatsText = new TextBlock();
                        //SeatsText.Width = 35;
                        //SeatsText.Height = 20;
                        //SeatsText.VerticalAlignment = VerticalAlignment.Center;
                        //SeatsText.HorizontalAlignment = HorizontalAlignment.Center;
                        //SeatsText.Margin = new Thickness(0, 0, 0, 0);
                        //SeatsText.SetValue(Grid.RowProperty, 2);
                        //SeatsText.Text = string.Format("{0} seat(s)", TableLayout.TableCapacity);
                        //SeatsText.FontSize = 12;
                        //SeatsText.FontWeight = FontWeights.Bold;
                        //SeatsText.TextWrapping = TextWrapping.Wrap;

                        TableGrid.Children.Add(finalImage);
                        TableGrid.Children.Add(TitleText);
                        //TableGrid.Children.Add(SeatsText);


                        double leftPosition = string.IsNullOrEmpty(TableLayout.TablePosition) ? 10 : Convert.ToDouble(TableLayout.TablePosition.Substring(0, TableLayout.TablePosition.IndexOf(',')));
                        double topPosition = string.IsNullOrEmpty(TableLayout.TablePosition) ? 10 : Convert.ToDouble(TableLayout.TablePosition.Substring(TableLayout.TablePosition.IndexOf(',') + 1,
                        TableLayout.TablePosition.Length - TableLayout.TablePosition.IndexOf(',') - 1));

                        Canvas.SetLeft(TableGrid, leftPosition);
                        Canvas.SetTop(TableGrid, topPosition);
                        SelectCanvas.Children.Add(TableGrid);
                    }
                }
            }
        }

        private void CanvasMouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            
                var grid = e.Source.GetType().Equals(typeof(Image)) ? ((e.Source as Image).Parent as Grid) : e.Source as Grid;
                if ((e.Source as Image) != null && (e.Source as Image).Source.ToString().Contains("delete"))
                {
                    if (App.ConfirmationDialog("Do you want to remove the table", "Ei8ht POS"))
                    {
                        deleteImage_MouseLeftButtonUp(e.Source as Image);
                        return;
                    }
                }

                if (grid != null && MainCanvas.CaptureMouse())
                {
                    mousePosition = e.GetPosition(MainCanvas);
                    draggedGrid = grid;
                    Panel.SetZIndex(draggedGrid, 1); // in case of multiple images
                }
            
        }

        private void CanvasMouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            if (draggedGrid != null)
            {
                MainCanvas.ReleaseMouseCapture();
                Panel.SetZIndex(draggedGrid, 0);
                draggedGrid = null;
            }
        }

        private void CanvasMouseMove(object sender, MouseEventArgs e)
        {
            if (draggedGrid != null)
            {
                if (Convert.ToDouble(draggedGrid.GetValue(Canvas.TopProperty)) < 0)
                {
                    draggedGrid.SetValue(Canvas.TopProperty, 0.0);
                    return;
                }
                if (Convert.ToDouble(draggedGrid.GetValue(Canvas.LeftProperty)) < 0)
                {
                    draggedGrid.SetValue(Canvas.LeftProperty, 0.0);
                    return;
                }
                if (Convert.ToDouble(draggedGrid.GetValue(Canvas.LeftProperty)) > MainCanvas.ActualWidth - draggedGrid.Width)
                {
                    draggedGrid.SetValue(Canvas.LeftProperty, MainCanvas.ActualWidth - draggedGrid.Width);
                    return;
                }
                if (Convert.ToDouble(draggedGrid.GetValue(Canvas.TopProperty)) > MainCanvas.ActualHeight - draggedGrid.Height)
                {
                    draggedGrid.SetValue(Canvas.TopProperty, MainCanvas.ActualHeight - draggedGrid.Height);
                    return;
                }
                var position = e.GetPosition(MainCanvas);
                var offset = position - mousePosition;
                mousePosition = position;
                Canvas.SetLeft(draggedGrid, Canvas.GetLeft(draggedGrid) + offset.X);
                Canvas.SetTop(draggedGrid, Canvas.GetTop(draggedGrid) + offset.Y);
            }
        }

        private void deleteImage_MouseLeftButtonUp(Image sender)
        {
            Image deleteImage = sender;
            Grid GridToDelete = deleteImage.Parent as Grid;
            Guid LayoutID = Guid.Parse(GridToDelete.Tag.ToString());
            if (LayoutID != Guid.Empty)
                LayoutBL.Delete(LayoutID);
            if (GridToDelete != null)
                MainCanvas.Children.Remove(GridToDelete);
        }

        private void btnSave_Click(object sender, RoutedEventArgs e)
        {
            List<Layouts> Tables = new List<Layouts>();
            Layouts Table;
            string TableName;
            for (int rowCount = 0; rowCount < MainCanvas.Children.Count; rowCount++)
            {
                Table = new Layouts();
                TableName = ((MainCanvas.Children[rowCount] as Grid).Children[1] as TextBox).Text;
                if (string.IsNullOrEmpty(TableName))
                {
                    MessageBox.Show("Please enter a name for all tables.", "Error", MessageBoxButton.OK, MessageBoxImage.Exclamation);
                    return;
                }
                if (Tables.Where(a => a.TableName.Equals(TableName)).Any())
                {
                    MessageBox.Show("A Table with the same name already exists. Please check the table names before saving", "Error", MessageBoxButton.OK, MessageBoxImage.Exclamation);
                    return;
                }
                else
                {
                    Table.TableName = TableName;
                }
                if (ValidationUtility.ValidateInt(((MainCanvas.Children[rowCount] as Grid).Children[4] as TextBox).Text))
                {
                    Table.TableCapacity = int.Parse(((MainCanvas.Children[rowCount] as Grid).Children[4] as TextBox).Text);
                }
                else
                {
                    MessageBox.Show("Number of table seats should be a numeric value", "Error", MessageBoxButton.OK, MessageBoxImage.Exclamation);
                    return;
                }
                Table.TablePosition = string.Format("{0},{1}", (MainCanvas.Children[rowCount] as Grid).GetValue(Canvas.LeftProperty),
                    (MainCanvas.Children[rowCount] as Grid).GetValue(Canvas.TopProperty));

                Table.TableID = Guid.Parse((MainCanvas.Children[rowCount] as Grid).Tag.ToString());

                //Table.TableCapacity = int.Try

                Image TypeImage = (MainCanvas.Children[rowCount] as Grid).Children[0] as Image;
                switch (TypeImage.Source.ToString())
                {
                    case IMG_BarStool:
                        Table.TableType = FT_BarStool;
                        break;
                    case IMG_Table:
                        Table.TableType = FT_Table;
                        break;
                    case IMG_Sofa:
                        Table.TableType = FT_Sofa;
                        break;
                    default: break;
                }



                Tables.Add(Table);
            }

            try
            {
                foreach (Layouts lt in Tables)
                {
                    LayoutBL.Save(lt);
                }
                LoadSelectTables();
                MessageBox.Show("Table layout saved successfully!");
            }
            catch
            {
                MessageBox.Show("Tables can't be updated at this time. Please try again after sometime or contact the administrator.", "Problem in saving Layout", MessageBoxButton.OK, MessageBoxImage.Exclamation);
            }
        }

        protected void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.Tag = false;
            this.Close();
        }

        private void SelectCanvas_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            var grid = e.Source.GetType().Equals(typeof(Image)) ? ((e.Source as Image).Parent as Grid) : e.Source as Grid;
            if (grid != null)
            {
                List<Layouts> Tables = LayoutBL.GetList(Guid.Empty);
                if (Tables != null && Tables.Count > 0)
                {
                    Tables = Tables.Where(a => a.IsActive).ToList<Layouts>();
                }
                Guid TableID = Guid.Parse(grid.Tag.ToString());
                AppSession.CurrentOrders = (AppSession.CurrentOrders == null) ? new Orders() : AppSession.CurrentOrders;
                AppSession.CurrentOrders.TableNumber = Tables.Where(a => a.TableID == TableID).Select(a => a.TableName).Single();
                this.Tag = true;
                this.Close();
                //MessageBox.Show(AppSession.CurrentOrders.TableNumber);
            }
        }
    }
}
